'Login Ver 2.bas

Option EXPLICIT
Option DEFAULT NONE
Option autorun on
option base 1

const True = 1
Const False = 0
const WatchdogOn = True
const LoggedTime = 60000 'set the login timout to 60 seconds

const SetPwd = "1234" 'set the password to whatever is wanted - 1234 is simple to enter!
dim Integer PassWordOK = False 'set a flag
dim string Pwd = "" 'define the password
dim String PassKey = "" 'define the passkey

if WatchdogOn then watchdog 60000
timer = 0
do while mm.info(ip address) = "0.0.0.0"
  if timer > 5000 then print "WiFi Timeout, rebooting.": pause 500: cpu restart
  if timer < 1000 then print "Waiting for WiFi."
  pause 1000
loop
print "Connected to WiFi. IP Address is " + mm.info$(ip address)

WEB TCP INTERRUPT WebInterrupt

'---- Main program loop ----
do
  if WatchdogOn then Watchdog 20000
loop

'---- web related here ----
sub WebInterrupt
  local Integer ConnNum 
  local integer ConnData(512)
  for ConnNum = 1 to mm.info(Max Connections) 'loop through the connections
    longstring clear ConnData()
    PassWordOK = False 'set the flag to false
    web tcp read ConnNum, ConnData() 'read the data
    if llen(ConnData()) > 0 then 'is there a string in it?
      if linstr(ConnData(), "GET /password.html") > 0 then 'looking for password page?
        web transmit page ConnNum, "/password.html" 'send it
        web tcp close ConnNum 'close the connection because we're done
        exit sub 'get out
      endif
      if linstr(ConnData(), "pwd=") > 0 then 'is there a password string in the request? probably sent from the login page
        PassWordOK = IsValidPwd (ConnData()) 'check if the Password matches
        if PassWordOK then 'if it's a match
          web transmit page ConnNum, "/index.html" 'send the index page
          web tcp close ConnNum 'close the connection because we're done
          exit sub 'get out
        else
          Pwd = "" 'housekeeping pwd reset
          PassKey = "" 'housekeeping passkey reset
          web transmit page ConnNum, "/password.html" 'otherwise, send the login page again
          web tcp close ConnNum 'close the connection because we're done
          exit sub 'get out
        endif
      endif
      if linstr(ConnData(), PassKey , 1) > 0 then 'if the previously generated passkey string anywhere in the request, we can proceed
        If (LInStr(ConnData(),"GET / HTTP") > 0) Or (LInStr(ConnData(),"GET /index") > 0) Then 'looking for index page
          ? "Sending index.html" 'debug print
          WEB TRANSMIT PAGE ConnNum, "/index.html" 'send it
        elseif linstr(ConnData(), "GET /debug") > 0 then 'looking for debug page
          ? "Sending debug.html" 'debug print
          WEB TRANSMIT PAGE ConnNum, "/debug.html" 'send it
        elseif linstr(ConnData(), "GET /channel") > 0 then 'channel setup page
          ? "Sending channel setup.html" 'debug print
          WEB TRANSMIT PAGE ConnNum, "/channel.html" 'send it
        elseif linstr(ConnData(), "GET /system") > 0 then 'system setup page
          ? "Sending system setup.html" 'debug print
          WEB TRANSMIT PAGE ConnNum, "/system.html" 'send it
        elseif linstr(ConnData(), "GET /manual") > 0 then 'manual override page
          ? "Sending manual.html" 'debug print
          WEB TRANSMIT PAGE ConnNum, "/manual.html" 'send it
        elseif linstr(ConnData(), "Channel=") > 0 then 'a flag to change the channel number for setup
          ? "Channel Changed, resending channel setup.html" 'debug print
          WEB TRANSMIT PAGE ConnNum, "/channel.html" 'send it
        else 'nothing matches, it's a boo-boo
          ? "Page Not Found" 'debug print
          WEB TRANSMIT CODE ConnNum, 404 'Send the page not found error, just in case
          web tcp close ConnNum
          exit sub
        endif
        settick LoggedTime, LoginTimeout, 4
      else
        Pwd = "" 'reset pwd
        PassKey ="" 'reset passkey
        PassWordOK = False 'reset password ok flag
        settick 0, 0, 4 'turnoff the interrupt    
        web transmit page ConnNum, "/password.html" 'otherwise, send the login page
      endif
    endif
    'web tcp close ConnNum 'close the connection for good housekeeping
  next ConnNum 'keep checking
end sub

'---- security function here to check for a (correct) password ----
function IsValidPwd (ConnData() as integer) as integer 'check our password and generate a passkey
  local integer StartPos, Endpos, StrLen, i, TmpVal
  local string TmpStr
  IsValidPwd = False 'default value to false ONLY changed when the password is correct
  StartPos = (linstr(ConnData(), "pwd=", 1)) + 4 'where is the password string starting from?
  StrLen = (llen(ConnData()) - StartPos) + 1 ' how long is it?
  if StrLen > 0 then 'if it's not a zero length string (ie: SOMEthing was entered)
    Pwd = lgetstr$(ConnData(), StartPos, StrLen) 'get the entered password string
    if Pwd = SetPwd then 'if the entered password ='s the set password
        for i = 1 to 25 'do a loop here 25 times minimum
        TmpVal = int((math(rand) * 70) + 48) 'generate a random value
        select case TmpVal 'what is the value of the integer
          case 48 to 57 '0 to 9?
            TmpStr = TmpStr + chr$(TmpVal) 'convert to a Char and add to the string
          case 65 to 90 'A to Z?
            TmpStr = TmpStr + chr$(TmpVal) 'convert to a Char and add to the string
          case 97 to 122 'a t z?
            TmpStr = TmpStr + chr$(TmpVal) 'convert to a Char and add to the string
          case else 'none of the above because we only want printable chars
            i = i - 1 'sub the loop value to keep going to get the 25 characters needed
        end select
      next i
      PassKey = TmpStr 'assign the string to the temporary 25 bit security passkey
      settick LoggedTime, LoginTimeout, 4
      IsValidPwd = True 'the password was valid, set the bit
    else 'otherwise
      Pwd = "" 'clear the password
      PassKey = "" 'clear the passkey
      IsValidPwd = False 'a valid password was not found
    endif
  endif
end function

sub LoginTimeout
  ? "Login Timeout" 'debug print
  Pwd = "" 'reset the pwd
  PassKey = "" 'reset the passkey
  PassWordOK = False 'reset the password ok flag
  settick 0, 0, 4 'turn off the interrupt
end sub
